/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledCreaturePermanent;

class TourachsChantEffect
extends OneShotEffect {
    TourachsChantEffect() {
        super(Outcome.Damage);
        this.staticText = "{this} deals 3 damage to that player unless they put a -1/-1 counter on a creature they control";
    }

    private TourachsChantEffect(TourachsChantEffect effect) {
        super((OneShotEffect)effect);
    }

    public TourachsChantEffect copy() {
        return new TourachsChantEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        Permanent sourcePermanent = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (player != null && sourcePermanent != null) {
            Permanent permanent;
            boolean paid = false;
            TargetControlledCreaturePermanent target = new TargetControlledCreaturePermanent();
            target.withNotTarget(true);
            if (player.chooseUse(Outcome.Detriment, "Put a -1/-1 counter on a creature you control? (otherwise " + sourcePermanent.getLogName() + " deals 3 damage to you)", source, game) && player.choose(Outcome.UnboostCreature, (Target)target, source, game) && (permanent = game.getPermanent(target.getFirstTarget())) != null) {
                permanent.addCounters(CounterType.M1M1.createInstance(), player.getId(), source, game);
                paid = true;
            }
            if (!paid) {
                player.damage(3, source.getSourceId(), source, game);
            }
            return true;
        }
        return false;
    }
}

