/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class TownGreeterEffect
extends OneShotEffect {
    TownGreeterEffect() {
        super(Outcome.Benefit);
        this.staticText = "mill four cards. You may put a land card from among them into your hand. If you put a Town card into your hand this way, you gain 2 life";
    }

    private TownGreeterEffect(TownGreeterEffect effect) {
        super((OneShotEffect)effect);
    }

    public TownGreeterEffect copy() {
        return new TownGreeterEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Cards cards = player.millCards(4, source, game);
        if (cards.isEmpty()) {
            return false;
        }
        TargetCard target = new TargetCard(0, 1, Zone.ALL, (FilterCard)StaticFilters.FILTER_CARD_LAND_A);
        target.withNotTarget(true);
        player.choose(Outcome.DrawCard, cards, target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        if (card == null) {
            return true;
        }
        player.moveCards(card, Zone.HAND, source, game);
        if (card.hasSubtype(SubType.TOWN, game)) {
            player.gainLife(2, game, source);
        }
        return true;
    }
}

