/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DestroyTargetEffect;
import mage.abilities.effects.common.ExileGraveyardAllTargetPlayerEffect;
import mage.abilities.effects.common.GainLifeEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.TargetPlayer;

class TranquilFrillbackEffect
extends OneShotEffect {
    private static ReflexiveTriggeredAbility makeAbility() {
        ReflexiveTriggeredAbility ability = new ReflexiveTriggeredAbility((Effect)new DestroyTargetEffect(), false);
        ability.addTarget((Target)new TargetPermanent((FilterPermanent)StaticFilters.FILTER_PERMANENT_ARTIFACT_OR_ENCHANTMENT));
        ability.addMode(new Mode((Effect)new ExileGraveyardAllTargetPlayerEffect()).addTarget((Target)new TargetPlayer()));
        ability.addMode(new Mode((Effect)new GainLifeEffect(4)));
        ability.getModes().setMinModes(0);
        ability.getModes().setChooseText("choose up to that many &mdash;");
        return ability;
    }

    TranquilFrillbackEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may pay {G} up to three times. When you pay this cost one or more times, " + TranquilFrillbackEffect.makeAbility().getRule();
    }

    private TranquilFrillbackEffect(TranquilFrillbackEffect effect) {
        super((OneShotEffect)effect);
    }

    public TranquilFrillbackEffect copy() {
        return new TranquilFrillbackEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        ManaCostsImpl cost;
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int count = 0;
        for (int i = 0; i < 3 && (cost = new ManaCostsImpl("{G}")).canPay(source, source, source.getControllerId(), game) && cost.pay(source, game, source, source.getControllerId(), false); ++i) {
            ++count;
        }
        if (count < 1) {
            return false;
        }
        ReflexiveTriggeredAbility ability = TranquilFrillbackEffect.makeAbility();
        ability.getModes().setMaxModes(count);
        game.fireReflexiveTriggeredAbility(ability, source);
        return true;
    }
}

