/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.function.Supplier;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.choices.Choice;
import mage.choices.ChoiceImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.BloodToken;
import mage.game.permanent.token.ClueArtifactToken;
import mage.game.permanent.token.FoodToken;
import mage.game.permanent.token.Token;
import mage.players.Player;

class TransmutationFontEffect
extends OneShotEffect {
    private static final Map<String, Supplier<Token>> map = new LinkedHashMap<String, Supplier<Token>>();

    TransmutationFontEffect() {
        super(Outcome.Benefit);
        this.staticText = "create your choice of a Blood token, a Clue token, or a Food token";
    }

    private TransmutationFontEffect(TransmutationFontEffect effect) {
        super((OneShotEffect)effect);
    }

    public TransmutationFontEffect copy() {
        return new TransmutationFontEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        ChoiceImpl choice = new ChoiceImpl(true);
        choice.setMessage("Choose a token to create");
        choice.setChoices(new LinkedHashSet<String>(map.keySet()));
        player.choose(this.outcome, (Choice)choice, game);
        Supplier tokenType = map.getOrDefault(choice.getChoice(), null);
        return tokenType != null && ((Token)tokenType.get()).putOntoBattlefield(1, game, source);
    }

    static {
        map.put("Blood", BloodToken::new);
        map.put("Clue", ClueArtifactToken::new);
        map.put("Food", FoodToken::new);
    }
}

