/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.common.ActivateIfConditionActivatedAbility;
import mage.abilities.condition.CompoundCondition;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.AfterBlockersAreDeclaredCondition;
import mage.abilities.condition.common.IsPhaseCondition;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.TapSourceCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.BecomeBlockedTargetEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.TurnPhase;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.permanent.AttackingPredicate;
import mage.filter.predicate.permanent.BlockedPredicate;
import mage.target.Target;
import mage.target.TargetPermanent;

public final class TrapRunner
extends CardImpl {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent("unblocked attacking creature");
    private static final Condition condition;

    public TrapRunner(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.CREATURE}, "{2}{W}{W}");
        this.subtype.add((Object)SubType.HUMAN);
        this.subtype.add((Object)SubType.SOLDIER);
        this.power = new MageInt(2);
        this.toughness = new MageInt(3);
        ActivateIfConditionActivatedAbility ability = new ActivateIfConditionActivatedAbility((Effect)new BecomeBlockedTargetEffect(), (Cost)new TapSourceCost(), condition);
        ability.addTarget((Target)new TargetPermanent((FilterPermanent)filter));
        this.addAbility((Ability)ability);
    }

    private TrapRunner(TrapRunner card) {
        super((CardImpl)card);
    }

    public TrapRunner copy() {
        return new TrapRunner(this);
    }

    static {
        filter.add((Predicate)AttackingPredicate.instance);
        filter.add(Predicates.not((Predicate)BlockedPredicate.instance));
        condition = new CompoundCondition("during combat after blockers are declared", new Condition[]{new IsPhaseCondition(TurnPhase.COMBAT), AfterBlockersAreDeclaredCondition.instance});
    }
}

