/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.players.Player;

class TrapfindersTrickEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard();

    TrapfindersTrickEffect() {
        super(Outcome.Discard);
        this.staticText = "Target player reveals their hand and discards all Trap cards";
    }

    private TrapfindersTrickEffect(TrapfindersTrickEffect effect) {
        super((OneShotEffect)effect);
    }

    public TrapfindersTrickEffect copy() {
        return new TrapfindersTrickEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getFirstTarget());
        if (player == null) {
            return false;
        }
        player.revealCards(source, player.getHand(), game);
        player.discard((Cards)new CardsImpl(player.getHand().getCards(filter, game)), false, source, game);
        return true;
    }

    static {
        filter.add((Predicate)SubType.TRAP.getPredicate());
    }
}

