/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.game.events.NumberOfTriggersEvent;

class TravelingChocoboEffect
extends ReplacementEffectImpl {
    TravelingChocoboEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "if a land or Bird you control entering the battlefield causes a triggered ability of a permanent you control to trigger, that ability triggers an additional time";
    }

    private TravelingChocoboEffect(TravelingChocoboEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public TravelingChocoboEffect copy() {
        return new TravelingChocoboEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.NUMBER_OF_TRIGGERS;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (!(event instanceof NumberOfTriggersEvent)) {
            return false;
        }
        NumberOfTriggersEvent numberOfTriggersEvent = (NumberOfTriggersEvent)event;
        if (!source.isControlledBy(event.getPlayerId())) {
            return false;
        }
        GameEvent sourceEvent = numberOfTriggersEvent.getSourceEvent();
        if (sourceEvent == null || sourceEvent.getType() != GameEvent.EventType.ENTERS_THE_BATTLEFIELD || !(sourceEvent instanceof EntersTheBattlefieldEvent)) {
            return false;
        }
        EntersTheBattlefieldEvent entersTheBattlefieldEvent = (EntersTheBattlefieldEvent)sourceEvent;
        return (entersTheBattlefieldEvent.getTarget().isLand(game) || entersTheBattlefieldEvent.getTarget().hasSubtype(SubType.BIRD, game)) && entersTheBattlefieldEvent.getTarget().isControlledBy(source.getControllerId()) && game.getPermanent(numberOfTriggersEvent.getSourceId()) != null;
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        event.setAmount(event.getAmount() + 1);
        return false;
    }
}

