/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.t.TravelingPlagueEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;

class TravelingPlagueTriggeredAbility
extends TriggeredAbilityImpl {
    public TravelingPlagueTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new TravelingPlagueEffect(), false);
        this.setTriggerPhrase("When enchanted creature leaves the battlefield, ");
    }

    private TravelingPlagueTriggeredAbility(TravelingPlagueTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public TravelingPlagueTriggeredAbility copy() {
        return new TravelingPlagueTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        if (zEvent.getFromZone() != Zone.BATTLEFIELD) {
            return false;
        }
        Permanent enchantedCreature = game.getPermanentOrLKIBattlefield(event.getTargetId());
        Permanent travelingPlague = game.getPermanentOrLKIBattlefield(this.sourceId);
        if (enchantedCreature == null || !enchantedCreature.getAttachments().contains(travelingPlague.getId())) {
            return false;
        }
        game.getState().setValue("travelingPlague" + this.sourceId, (Object)enchantedCreature);
        return true;
    }
}

