/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class TreasureChestEffect
extends OneShotEffect {
    TreasureChestEffect() {
        super(Outcome.Benefit);
        this.staticText = "search your library for a card. If it's an artifact card, you may put it onto the battlefield. Otherwise, put that card into your hand. Then shuffle";
    }

    private TreasureChestEffect(TreasureChestEffect effect) {
        super((OneShotEffect)effect);
    }

    public TreasureChestEffect copy() {
        return new TreasureChestEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetCardInLibrary target = new TargetCardInLibrary();
        player.searchLibrary(target, source, game);
        Card card = player.getLibrary().getCard(target.getFirstTarget(), game);
        if (card == null) {
            player.shuffleLibrary(source, game);
            return true;
        }
        if (CardType.ARTIFACT.getPredicate().apply((MageObject)card, game) && player.chooseUse(Outcome.PlayForFree, "Put it onto the battlefield or your hand?", null, "Battlefield", "Hand", source, game)) {
            player.moveCards(card, Zone.BATTLEFIELD, source, game);
        } else {
            player.moveCards(card, Zone.HAND, source, game);
        }
        player.shuffleLibrary(source, game);
        return true;
    }
}

