/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class TreasureHuntEffect
extends OneShotEffect {
    TreasureHuntEffect() {
        super(Outcome.DrawCard);
        this.staticText = "Reveal cards from the top of your library until you reveal a nonland card, then put all cards revealed this way into your hand";
    }

    private TreasureHuntEffect(TreasureHuntEffect effect) {
        super((OneShotEffect)effect);
    }

    public TreasureHuntEffect copy() {
        return new TreasureHuntEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && controller.getLibrary().hasCards()) {
            CardsImpl cards = new CardsImpl();
            for (Card card : controller.getLibrary().getCards(game)) {
                cards.add(card);
                if (card.isLand(game)) continue;
                break;
            }
            controller.revealCards(source, (Cards)cards, game);
            controller.moveCards((Cards)cards, Zone.HAND, source, game);
            return true;
        }
        return false;
    }
}

