/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.AttachEffect;
import mage.abilities.effects.common.combat.CantBeBlockedByCreaturesAttachedEffect;
import mage.abilities.effects.common.continuous.BoostEnchantedEffect;
import mage.abilities.keyword.EnchantAbility;
import mage.abilities.keyword.FlyingAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.AttachmentType;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.AbilityPredicate;
import mage.target.Target;
import mage.target.common.TargetCreaturePermanent;

public final class TreetopBracers
extends CardImpl {
    private static final FilterCreaturePermanent onlyFlyingCreatures = new FilterCreaturePermanent("except by creatures with flying");

    public TreetopBracers(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{1}{G}");
        this.subtype.add((Object)SubType.AURA);
        TargetCreaturePermanent auraTarget = new TargetCreaturePermanent();
        this.getSpellAbility().addTarget((Target)auraTarget);
        this.getSpellAbility().addEffect((Effect)new AttachEffect(Outcome.BoostCreature));
        EnchantAbility ability = new EnchantAbility((Target)auraTarget);
        this.addAbility((Ability)ability);
        ability = new SimpleStaticAbility((Effect)new BoostEnchantedEffect(1, 1, Duration.WhileOnBattlefield));
        ability.addEffect((Effect)new CantBeBlockedByCreaturesAttachedEffect(Duration.WhileOnBattlefield, onlyFlyingCreatures, AttachmentType.AURA).setText("and can't be blocked except by creatures with flying"));
        this.addAbility((Ability)ability);
    }

    private TreetopBracers(TreetopBracers card) {
        super((CardImpl)card);
    }

    public TreetopBracers copy() {
        return new TreetopBracers(this);
    }

    static {
        onlyFlyingCreatures.add(Predicates.not((Predicate)new AbilityPredicate(FlyingAbility.class)));
    }
}

