/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.SetBasePowerToughnessSourceEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterLandCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class TrenchGorgerEffect
extends OneShotEffect {
    TrenchGorgerEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "search your library for any number of land cards, exile them, then shuffle. If you do, {this} has base power and base toughness each equal to the number of cards exiled this way";
    }

    private TrenchGorgerEffect(TrenchGorgerEffect effect) {
        super((OneShotEffect)effect);
    }

    public TrenchGorgerEffect copy() {
        return new TrenchGorgerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        TargetCardInLibrary target = new TargetCardInLibrary(0, Integer.MAX_VALUE, (FilterCard)new FilterLandCard("any number of land cards"));
        boolean searched = target.choose(this.outcome, controller.getId(), controller.getId(), source, game);
        if (!searched) {
            return false;
        }
        int count = 0;
        for (UUID cardId : target.getTargets()) {
            Card card = game.getCard(cardId);
            if (card == null) continue;
            controller.moveCardToExileWithInfo(card, null, "", source, game, Zone.LIBRARY, true);
            ++count;
        }
        controller.shuffleLibrary(source, game);
        game.addEffect((ContinuousEffect)new SetBasePowerToughnessSourceEffect(count, count, Duration.WhileOnBattlefield), source);
        return true;
    }
}

