/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostAllEffect;
import mage.choices.Choice;
import mage.choices.ChoiceCreatureType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.players.Player;

class TribalUnityEffect
extends OneShotEffect {
    protected DynamicValue amount;

    public TribalUnityEffect(DynamicValue amount) {
        super(Outcome.UnboostCreature);
        this.staticText = "Creatures of the creature type of your choice get +X/+X until end of turn.";
        this.amount = amount;
    }

    private TribalUnityEffect(TribalUnityEffect effect) {
        super((OneShotEffect)effect);
        this.amount = effect.amount;
    }

    public boolean apply(Game game, Ability source) {
        MageObject sourceObject = game.getObject(source);
        if (sourceObject == null) {
            return false;
        }
        Player player = game.getPlayer(source.getControllerId());
        ChoiceCreatureType typeChoice = new ChoiceCreatureType(game, source);
        if (player != null && player.choose(this.outcome, (Choice)typeChoice, game)) {
            int boost = this.amount.calculate(game, source, (Effect)this);
            game.informPlayers(sourceObject.getLogName() + " chosen type: " + typeChoice.getChoiceKey());
            FilterCreaturePermanent filterCreaturePermanent = new FilterCreaturePermanent();
            filterCreaturePermanent.add((Predicate)SubType.byDescription((String)typeChoice.getChoiceKey()).getPredicate());
            game.addEffect((ContinuousEffect)new BoostAllEffect(boost, boost, Duration.EndOfTurn, filterCreaturePermanent, false), source);
            return true;
        }
        return false;
    }

    public TribalUnityEffect copy() {
        return new TribalUnityEffect(this);
    }
}

