/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DontUntapInControllersNextUntapStepTargetEffect;
import mage.cards.t.TritonTacticsWatcher;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;

class TritonTacticsTapEffect
extends OneShotEffect {
    private final Set<MageObjectReference> morSet = new HashSet<MageObjectReference>();

    TritonTacticsTapEffect(List<Permanent> permanents, Game game) {
        super(Outcome.Tap);
        permanents.stream().map(permanent -> new MageObjectReference((MageObject)permanent, game)).forEach(this.morSet::add);
    }

    private TritonTacticsTapEffect(TritonTacticsTapEffect effect) {
        super((OneShotEffect)effect);
        this.morSet.addAll(effect.morSet);
    }

    public TritonTacticsTapEffect copy() {
        return new TritonTacticsTapEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        List<Permanent> permanents = TritonTacticsWatcher.getPermanents(this.morSet, game);
        if (permanents.isEmpty()) {
            return false;
        }
        permanents.stream().forEach(permanent -> permanent.tap(source, game));
        game.addEffect(new DontUntapInControllersNextUntapStepTargetEffect().setTargetPointer((TargetPointer)new FixedTargets(permanents, game)), source);
        return true;
    }
}

