/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import mage.MageObjectReference;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.watchers.Watcher;

class TritonTacticsWatcher
extends Watcher {
    private final Map<MageObjectReference, Set<MageObjectReference>> map = new HashMap<MageObjectReference, Set<MageObjectReference>>();
    private static final Set<MageObjectReference> emptySet = Collections.unmodifiableSet(new HashSet());

    TritonTacticsWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.BLOCKER_DECLARED) {
            this.map.computeIfAbsent(new MageObjectReference(event.getSourceId(), game), x -> new HashSet()).add(new MageObjectReference(event.getTargetId(), game));
        }
    }

    public void reset() {
        super.reset();
        this.map.clear();
    }

    static List<Permanent> getPermanents(Set<MageObjectReference> targets, Game game) {
        TritonTacticsWatcher watcher = (TritonTacticsWatcher)game.getState().getWatcher(TritonTacticsWatcher.class);
        return targets.stream().map(mor -> watcher.map.getOrDefault(mor, emptySet)).flatMap(Collection::stream).map(mor -> mor.getPermanent(game)).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

