/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.PermanentsOnBattlefieldCount;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.counter.ProliferateEffect;
import mage.abilities.hint.Hint;
import mage.abilities.hint.ValueHint;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.EnteredThisTurnPredicate;
import mage.filter.predicate.permanent.TokenPredicate;
import mage.game.Game;

class TromellSeymoursButlerEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledCreaturePermanent();
    private static final Hint hint;

    TromellSeymoursButlerEffect() {
        super(Outcome.Benefit);
        this.staticText = "proliferate X times, where X is the number of nontoken creatures you control that entered this turn";
    }

    private TromellSeymoursButlerEffect(TromellSeymoursButlerEffect effect) {
        super((OneShotEffect)effect);
    }

    public TromellSeymoursButlerEffect copy() {
        return new TromellSeymoursButlerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int count = game.getBattlefield().count(filter, source.getControllerId(), source, game);
        if (count < 1) {
            return false;
        }
        ProliferateEffect effect = new ProliferateEffect();
        for (int i = 0; i < count; ++i) {
            effect.apply(game, source);
        }
        return true;
    }

    public static Hint getHint() {
        return hint;
    }

    static {
        filter.add((Predicate)TokenPredicate.FALSE);
        filter.add((Predicate)EnteredThisTurnPredicate.instance);
        hint = new ValueHint("Nontoken creatures you control that entered this turn", (DynamicValue)new PermanentsOnBattlefieldCount(filter));
    }
}

