/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;
import mage.watchers.common.CardsDrawnThisTurnWatcher;
import mage.watchers.common.CastSpellLastTurnWatcher;

class TroubleInPairsTriggeredAbility
extends TriggeredAbilityImpl {
    TroubleInPairsTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DrawCardSourceControllerEffect(1));
    }

    private TroubleInPairsTriggeredAbility(TroubleInPairsTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public TroubleInPairsTriggeredAbility copy() {
        return new TroubleInPairsTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DECLARED_ATTACKERS || event.getType() == GameEvent.EventType.DREW_CARD || event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Player controller = game.getPlayer(this.getControllerId());
        if (controller == null || !game.getOpponents(this.getControllerId()).contains(event.getPlayerId())) {
            return false;
        }
        switch (event.getType()) {
            case DECLARED_ATTACKERS: {
                return game.getCombat().getAttackers().stream().map(uuid -> game.getCombat().getDefendingPlayerId(uuid, game)).filter(this.getControllerId()::equals).count() >= 2L;
            }
            case DREW_CARD: {
                CardsDrawnThisTurnWatcher drawWatcher = (CardsDrawnThisTurnWatcher)game.getState().getWatcher(CardsDrawnThisTurnWatcher.class);
                return drawWatcher != null && drawWatcher.getCardsDrawnThisTurn(event.getPlayerId()) == 2;
            }
            case SPELL_CAST: {
                CastSpellLastTurnWatcher spellWatcher = (CastSpellLastTurnWatcher)game.getState().getWatcher(CastSpellLastTurnWatcher.class);
                return spellWatcher != null && spellWatcher.getAmountOfSpellsPlayerCastOnCurrentTurn(event.getPlayerId()) == 2;
            }
        }
        return false;
    }

    public String getRule() {
        return "Whenever an opponent attacks you with two or more creatures, draws their second card each turn, or casts their second spell each turn, you draw a card.";
    }
}

