/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class TruceEffect
extends OneShotEffect {
    TruceEffect() {
        super(Outcome.DrawCard);
        this.staticText = "Each player may draw up to two cards. For each card less than two a player draws this way, that player gains 2 life";
    }

    private TruceEffect(TruceEffect effect) {
        super((OneShotEffect)effect);
    }

    public TruceEffect copy() {
        return new TruceEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
                Player player = game.getPlayer(playerId);
                if (player == null) continue;
                int cardsToDraw = player.getAmount(0, 2, "Draw how many cards?", source, game);
                player.drawCards(cardsToDraw, source, game);
                player.gainLife((2 - cardsToDraw) * 2, game, source);
            }
            return true;
        }
        return false;
    }
}

