/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.util.functions.CopyApplier;
import mage.util.functions.EmptyCopyApplier;

class TruePolymorphEffect
extends OneShotEffect {
    TruePolymorphEffect() {
        super(Outcome.Benefit);
        this.staticText = "target artifact or creature becomes a copy of another target artifact or creature";
    }

    private TruePolymorphEffect(TruePolymorphEffect effect) {
        super((OneShotEffect)effect);
    }

    public TruePolymorphEffect copy() {
        return new TruePolymorphEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent copyTo = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (copyTo == null) {
            return false;
        }
        Permanent copyFrom = game.getPermanentOrLKIBattlefield(((Target)source.getTargets().get(1)).getFirstTarget());
        if (copyFrom == null) {
            return false;
        }
        game.copyPermanent(Duration.Custom, copyFrom, copyTo.getId(), source, (CopyApplier)new EmptyCopyApplier());
        return true;
    }
}

