/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.condition.common.MostCommonColorCondition;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DestroyTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class TsabosAssasinEffect
extends OneShotEffect {
    TsabosAssasinEffect() {
        super(Outcome.Detriment);
        this.staticText = "Destroy target creature if it shares a color with the most common color among all permanents or a color tied for most common. A creature destroyed this way can't be regenerated.";
    }

    private TsabosAssasinEffect(TsabosAssasinEffect effect) {
        super((OneShotEffect)effect);
    }

    public TsabosAssasinEffect copy() {
        return new TsabosAssasinEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        MostCommonColorCondition condition;
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent != null && (condition = new MostCommonColorCondition(permanent.getColor(game))).apply(game, source)) {
            DestroyTargetEffect effect = new DestroyTargetEffect();
            effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
            return effect.apply(game, source);
        }
        return false;
    }
}

