/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.choices.Choice;
import mage.choices.ChoiceCreatureType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class TsabosDecreeEffect
extends OneShotEffect {
    TsabosDecreeEffect() {
        super(Outcome.UnboostCreature);
        this.staticText = "Choose a creature type. Target player reveals their hand and discards all creature cards of that type. Then destroy all creatures of that type that player controls. They can't be regenerated";
    }

    private TsabosDecreeEffect(TsabosDecreeEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Player targetPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        MageObject sourceObject = game.getObject(source);
        if (player == null) {
            return false;
        }
        if (sourceObject == null) {
            return false;
        }
        ChoiceCreatureType typeChoice = new ChoiceCreatureType(game, source);
        if (!player.choose(this.outcome, (Choice)typeChoice, game)) {
            return false;
        }
        game.informPlayers(sourceObject.getLogName() + " chosen type: " + typeChoice.getChoiceKey());
        targetPlayer.revealCards("hand of " + targetPlayer.getName(), targetPlayer.getHand(), game);
        FilterCard filterCard = new FilterCard();
        filterCard.add((Predicate)SubType.byDescription((String)typeChoice.getChoiceKey()).getPredicate());
        targetPlayer.discard((Cards)new CardsImpl(targetPlayer.getHand().getCards(filterCard, game)), false, source, game);
        FilterCreaturePermanent filterCreaturePermanent = new FilterCreaturePermanent();
        filterCreaturePermanent.add((Predicate)SubType.byDescription((String)typeChoice.getChoiceKey()).getPredicate());
        for (Permanent creature : game.getBattlefield().getActivePermanents((FilterPermanent)filterCreaturePermanent, source.getSourceId(), game)) {
            if (!creature.isControlledBy(targetPlayer.getId())) continue;
            creature.destroy(source, game, true);
        }
        return true;
    }

    public TsabosDecreeEffect copy() {
        return new TsabosDecreeEffect(this);
    }
}

