/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class TuktukScrapperEffect
extends OneShotEffect {
    private static final FilterControlledPermanent filter = new FilterControlledPermanent();

    public TuktukScrapperEffect() {
        super(Outcome.DestroyPermanent);
    }

    private TuktukScrapperEffect(TuktukScrapperEffect effect) {
        super((OneShotEffect)effect);
    }

    public TuktukScrapperEffect copy() {
        return new TuktukScrapperEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent targetArtifact = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && targetArtifact != null) {
            int alliesControlled;
            targetArtifact.destroy(source, game, false);
            Player targetController = game.getPlayer(targetArtifact.getControllerId());
            if (targetController != null && game.getState().getZone(targetArtifact.getId()) == Zone.GRAVEYARD && (alliesControlled = game.getBattlefield().count((FilterPermanent)filter, source.getControllerId(), source, game)) > 0) {
                targetController.damage(alliesControlled, source.getSourceId(), source, game);
            }
            return true;
        }
        return false;
    }

    static {
        filter.add((Predicate)SubType.ALLY.getPredicate());
    }
}

