/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.t.TuktukScrapperEffect;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.target.common.TargetArtifactPermanent;

class TuktukScrapperTriggeredAbility
extends TriggeredAbilityImpl {
    public TuktukScrapperTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new TuktukScrapperEffect(), true);
        this.addTarget((Target)new TargetArtifactPermanent());
    }

    private TuktukScrapperTriggeredAbility(TuktukScrapperTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public TuktukScrapperTriggeredAbility copy() {
        return new TuktukScrapperTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent = game.getPermanent(event.getTargetId());
        if (permanent != null) {
            if (permanent.getId().equals(this.getSourceId())) {
                return true;
            }
            return permanent.hasSubtype(SubType.ALLY, game) && permanent.isControlledBy(this.getControllerId());
        }
        return false;
    }

    public String getRule() {
        String condensedText = "Whenever {this} or another Ally you you control enters, you may destroy target artifact. If you do, {this} deals damage to that controller equal to the number of Allies you control.";
        return condensedText;
    }
}

