/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.cards.t.TunnelIgnusWatcher;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class TunnelIgnusTriggeredAbility
extends TriggeredAbilityImpl {
    TunnelIgnusTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DamageTargetEffect(3));
    }

    private TunnelIgnusTriggeredAbility(TunnelIgnusTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public TunnelIgnusTriggeredAbility copy() {
        return new TunnelIgnusTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        TunnelIgnusWatcher watcher;
        Permanent permanent = game.getPermanent(event.getTargetId());
        if (permanent != null && permanent.isLand(game) && game.getOpponents(this.controllerId).contains(permanent.getControllerId()) && (watcher = (TunnelIgnusWatcher)game.getState().getWatcher(TunnelIgnusWatcher.class, this.controllerId)) != null && watcher.counts.get(permanent.getControllerId()) > 1) {
            for (Effect effect : this.getEffects()) {
                effect.setTargetPointer((TargetPointer)new FixedTarget(permanent.getControllerId()));
            }
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever a land enters the battlefield under an opponent's control, if that player had another land enter the battlefield under their control this turn, {this} deals 3 damage to that player.";
    }
}

