/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.watchers.Watcher;

class TunnelIgnusWatcher
extends Watcher {
    protected Map<UUID, Integer> counts = new HashMap<UUID, Integer>();

    public TunnelIgnusWatcher() {
        super(WatcherScope.PLAYER);
    }

    public void watch(GameEvent event, Game game) {
        Permanent permanent;
        if (event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD && (permanent = game.getPermanent(event.getTargetId())) != null && permanent.isLand(game) && game.getOpponents(this.controllerId).contains(permanent.getControllerId())) {
            int count = this.counts.getOrDefault(permanent.getControllerId(), 0);
            this.counts.put(permanent.getControllerId(), count + 1);
        }
    }

    public void reset() {
        super.reset();
        this.counts.clear();
    }
}

