/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.Counter;
import mage.counters.CounterType;
import mage.counters.Counters;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInLibrary;

class TurntimberSymbiosisEffect
extends OneShotEffect {
    TurntimberSymbiosisEffect() {
        super(Outcome.Benefit);
        this.staticText = "Look at the top seven cards of your library. You may put a creature card from among them onto the battlefield. If that card has mana value 3 or less, it enters with three additional +1/+1 counters on it. Put the rest on the bottom of your library in a random order";
    }

    private TurntimberSymbiosisEffect(TurntimberSymbiosisEffect effect) {
        super((OneShotEffect)effect);
    }

    public TurntimberSymbiosisEffect copy() {
        return new TurntimberSymbiosisEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(player.getLibrary().getTopCards(game, 7));
        TargetCardInLibrary target = new TargetCardInLibrary(0, 1, (FilterCard)StaticFilters.FILTER_CARD_CREATURE);
        player.choose(this.outcome, (Cards)cards, (TargetCard)target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        if (card != null) {
            cards.remove(card);
            if (card.getManaValue() <= 3) {
                Counters countersToAdd = new Counters(new Counter[0]);
                countersToAdd.addCounter(CounterType.P1P1.createInstance(3));
                game.setEnterWithCounters(card.getId(), countersToAdd);
            }
            player.moveCards(card, Zone.BATTLEFIELD, source, game);
        }
        player.putCardsOnBottomOfLibrary((Cards)cards, game, source, false);
        return true;
    }
}

