/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.util.CardUtil;

class TwinflameTyrantEffect
extends ReplacementEffectImpl {
    TwinflameTyrantEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Damage);
        this.staticText = "if a source you control would deal damage to an opponent or a permanent an opponent controls, it deals double that damage instead";
    }

    private TwinflameTyrantEffect(TwinflameTyrantEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public TwinflameTyrantEffect copy() {
        return new TwinflameTyrantEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        switch (event.getType()) {
            case DAMAGE_PLAYER: 
            case DAMAGE_PERMANENT: {
                return true;
            }
        }
        return false;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (!source.isControlledBy(game.getControllerId(event.getSourceId()))) {
            return false;
        }
        switch (event.getType()) {
            case DAMAGE_PLAYER: {
                return game.getOpponents(source.getControllerId()).contains(event.getTargetId());
            }
            case DAMAGE_PERMANENT: {
                return game.getOpponents(source.getControllerId()).contains(game.getControllerId(event.getTargetId()));
            }
        }
        return false;
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        event.setAmount(CardUtil.overflowMultiply((int)event.getAmount(), (int)2));
        return false;
    }
}

