/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;

class TwinningStaffEffect
extends ReplacementEffectImpl {
    TwinningStaffEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "If you would copy a spell one or more times, instead copy it that many times plus an additional time. You may choose new targets for the additional copy.";
    }

    private TwinningStaffEffect(TwinningStaffEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        event.setAmount(event.getAmount() + 1);
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.COPY_STACKOBJECT;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return event.getPlayerId().equals(source.getControllerId()) && game.getSpellOrLKIStack(event.getTargetId()) != null && event.getAmount() >= 1;
    }

    public TwinningStaffEffect copy() {
        return new TwinningStaffEffect(this);
    }
}

