/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.combat.CantBlockAllEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValueParityPredicate;
import mage.game.Game;
import mage.players.Player;

class TwinsOfDiscordEffect
extends OneShotEffect {
    private static final FilterCreaturePermanent evenFilter = new FilterCreaturePermanent();
    private static final FilterCreaturePermanent oddFilter = new FilterCreaturePermanent();

    TwinsOfDiscordEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose odd or even. Creatures with mana value of that quality can't block this turn.";
    }

    private TwinsOfDiscordEffect(TwinsOfDiscordEffect effect) {
        super((OneShotEffect)effect);
    }

    public TwinsOfDiscordEffect copy() {
        return new TwinsOfDiscordEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        FilterCreaturePermanent filter;
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        FilterCreaturePermanent filterCreaturePermanent = filter = player.chooseUse(this.outcome, "Odd or even?", null, "Odd", "Even", source, game) ? oddFilter : evenFilter;
        if (filter == null) {
            return false;
        }
        game.addEffect((ContinuousEffect)new CantBlockAllEffect(filter, Duration.EndOfTurn), source);
        return true;
    }

    static {
        evenFilter.add((Predicate)ManaValueParityPredicate.EVEN);
        oddFilter.add((Predicate)ManaValueParityPredicate.ODD);
    }
}

