/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class TwoHandedAxeEffect
extends OneShotEffect {
    TwoHandedAxeEffect() {
        super(Outcome.Benefit);
        this.staticText = "double its power until end of turn";
    }

    private TwoHandedAxeEffect(TwoHandedAxeEffect effect) {
        super((OneShotEffect)effect);
    }

    public TwoHandedAxeEffect copy() {
        return new TwoHandedAxeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null || permanent.getPower().getValue() == 0) {
            return false;
        }
        game.addEffect(new BoostTargetEffect(permanent.getPower().getValue(), 0).setTargetPointer((TargetPointer)new FixedTarget(permanent, game)), source);
        return true;
    }
}

