/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.costs.common.PayLifeCost;
import mage.abilities.effects.OneShotEffect;
import mage.cards.t.TymnaTheWeaverWatcher;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class TymnaTheWeaverEffect
extends OneShotEffect {
    TymnaTheWeaverEffect() {
        super(Outcome.DrawCard);
        this.staticText = "you may pay X life, where X is the number of opponents that were dealt combat damage this turn. If you do, draw X cards";
    }

    private TymnaTheWeaverEffect(TymnaTheWeaverEffect effect) {
        super((OneShotEffect)effect);
    }

    public TymnaTheWeaverEffect copy() {
        return new TymnaTheWeaverEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        TymnaTheWeaverWatcher watcher;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && (watcher = (TymnaTheWeaverWatcher)game.getState().getWatcher(TymnaTheWeaverWatcher.class)) != null) {
            int cardsToDraw = watcher.opponentsThatGotCombatDamage(source.getControllerId(), game);
            PayLifeCost cost = new PayLifeCost(cardsToDraw);
            if (cost.canPay(source, source, source.getControllerId(), game) && cost.pay(source, game, source, source.getControllerId(), false)) {
                controller.drawCards(cardsToDraw, source, game);
            }
            return true;
        }
        return false;
    }
}

