/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.DamagedPlayerEvent;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;

class TymnaTheWeaverWatcher
extends Watcher {
    private final Map<UUID, Set<UUID>> players = new HashMap<UUID, Set<UUID>>();

    public TymnaTheWeaverWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        DamagedPlayerEvent dEvent;
        if (event.getType() == GameEvent.EventType.DAMAGED_PLAYER && (dEvent = (DamagedPlayerEvent)event).isCombatDamage()) {
            if (this.players.containsKey(event.getTargetId())) {
                this.players.get(event.getTargetId()).addAll(game.getOpponents(event.getTargetId()));
            } else {
                this.players.put(event.getTargetId(), game.getOpponents(event.getTargetId()));
            }
        }
    }

    public void reset() {
        super.reset();
        this.players.clear();
    }

    public int opponentsThatGotCombatDamage(UUID playerId, Game game) {
        int numberOfOpponents = 0;
        for (Set<UUID> opponents : this.players.values()) {
            if (!opponents.contains(playerId)) continue;
            ++numberOfOpponents;
        }
        return numberOfOpponents;
    }
}

