/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledPermanent;

class BloodClockEffect
extends OneShotEffect {
    BloodClockEffect() {
        super(Outcome.ReturnToHand);
        this.staticText = "that player returns a permanent they control to its owner's hand unless they pay 2 life";
    }

    private BloodClockEffect(BloodClockEffect effect) {
        super((OneShotEffect)effect);
    }

    public BloodClockEffect copy() {
        return new BloodClockEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent;
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player == null) {
            return false;
        }
        if (player.getLife() > 2 && player.chooseUse(Outcome.Neutral, "Pay 2 life? If you don't, return a permanent you control to its owner's hand.", source, game)) {
            player.loseLife(2, game, source, false);
            game.informPlayers(player.getLogName() + " pays 2 life. They will not return a permanent they control.");
            return true;
        }
        TargetControlledPermanent target = new TargetControlledPermanent();
        if (target.canChoose(player.getId(), source, game) && player.chooseTarget(this.outcome, (Target)target, source, game) && (permanent = game.getPermanent(target.getFirstTarget())) != null) {
            game.informPlayers(player.getLogName() + " returns " + permanent.getName() + " to hand.");
            return player.moveCards((Card)permanent, Zone.HAND, source, game);
        }
        return false;
    }
}

