/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import mage.abilities.Ability;
import mage.abilities.effects.CreateTokenCopySourceEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class UchuulonEffect
extends OneShotEffect {
    UchuulonEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile up to one target creature card from an opponent's graveyard. If you do, create a token that's a copy of {this}";
    }

    private UchuulonEffect(UchuulonEffect effect) {
        super((OneShotEffect)effect);
    }

    public UchuulonEffect copy() {
        return new UchuulonEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (player == null || card == null) {
            return false;
        }
        player.moveCards(card, Zone.EXILED, source, game);
        new CreateTokenCopySourceEffect().apply(game, source);
        return true;
    }
}

