/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.game.stack.StackObject;
import mage.util.CardUtil;

class UlalekFusedAtrocityEffect
extends OneShotEffect {
    UlalekFusedAtrocityEffect() {
        super(Outcome.Benefit);
        this.staticText = "copy all spells you control, then copy all other activated and triggered abilities you control. You may choose new targets for the copies";
    }

    private UlalekFusedAtrocityEffect(UlalekFusedAtrocityEffect effect) {
        super((OneShotEffect)effect);
    }

    public UlalekFusedAtrocityEffect copy() {
        return new UlalekFusedAtrocityEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        List spells = CardUtil.castStream((Stream)game.getStack().stream(), Spell.class).filter(spell -> spell.isControlledBy(source.getControllerId())).collect(Collectors.toList());
        for (Spell spell2 : spells) {
            spell2.createCopyOnStack(game, source, source.getControllerId(), true);
        }
        List abilities = game.getStack().stream().filter(obj -> !(obj instanceof Spell)).filter(obj -> obj.isControlledBy(source.getControllerId())).filter(obj -> !obj.getId().equals(source.getId())).collect(Collectors.toList());
        for (StackObject obj2 : abilities) {
            obj2.createCopyOnStack(game, source, source.getControllerId(), true);
        }
        return true;
    }
}

