/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import java.util.UUID;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class UlamogAttackTriggeredAbility
extends TriggeredAbilityImpl {
    public UlamogAttackTriggeredAbility(Effect effect) {
        super(Zone.BATTLEFIELD, effect);
        this.setTriggerPhrase("Whenever {this} attacks, ");
    }

    private UlamogAttackTriggeredAbility(UlamogAttackTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public UlamogAttackTriggeredAbility copy() {
        return new UlamogAttackTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ATTACKER_DECLARED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent sourcePermanent = game.getPermanentOrLKIBattlefield(this.getSourceId());
        if (sourcePermanent != null && event.getSourceId() != null && event.getSourceId().equals(this.getSourceId())) {
            UUID defender = game.getCombat().getDefendingPlayerId(this.getSourceId(), game);
            ((Effect)this.getEffects().get(0)).setTargetPointer((TargetPointer)new FixedTarget(defender));
            return true;
        }
        return false;
    }
}

