/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.mana.ColorlessManaAbility;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubTypeSet;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class UltimaOriginOfOblivionEffect
extends ContinuousEffectImpl {
    UltimaOriginOfOblivionEffect() {
        super(Duration.Custom, Outcome.Benefit);
        this.staticText = "For as long as that land has a blight counter on it, it loses all land types and abilities and has \"{T}: Add {C}.\"";
    }

    private UltimaOriginOfOblivionEffect(UltimaOriginOfOblivionEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public UltimaOriginOfOblivionEffect copy() {
        return new UltimaOriginOfOblivionEffect(this);
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null || !permanent.getCounters(game).containsKey(CounterType.BLIGHT)) {
            this.discard();
            return false;
        }
        switch (layer) {
            case TypeChangingEffects_4: {
                permanent.looseAllAbilities(game);
                permanent.addAbility((Ability)new ColorlessManaAbility(), source.getSourceId(), game);
                return true;
            }
            case AbilityAddingRemovingEffects_6: {
                permanent.removeAllSubTypes(game, SubTypeSet.NonBasicLandType);
                permanent.removeAllSubTypes(game, SubTypeSet.BasicLandType);
                return true;
            }
        }
        return false;
    }

    public boolean hasLayer(Layer layer) {
        switch (layer) {
            case TypeChangingEffects_4: 
            case AbilityAddingRemovingEffects_6: {
                return true;
            }
        }
        return false;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }
}

