/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class UmbrisFearManifestEffect
extends OneShotEffect {
    UmbrisFearManifestEffect() {
        super(Outcome.Benefit);
        this.staticText = "target opponent exiles cards from the top of their library until they exile a land card";
    }

    private UmbrisFearManifestEffect(UmbrisFearManifestEffect effect) {
        super((OneShotEffect)effect);
    }

    public UmbrisFearManifestEffect copy() {
        return new UmbrisFearManifestEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getFirstTarget());
        if (player == null) {
            return false;
        }
        for (Card card : player.getLibrary().getCards(game)) {
            player.moveCards(card, Zone.EXILED, source, game);
            if (!card.isLand(game)) continue;
            break;
        }
        return true;
    }
}

