/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.search.SearchLibraryPutInHandEffect;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.target.common.TargetCardInLibrary;
import mage.target.common.TargetCardWithDifferentNameInLibrary;
import mage.util.CardUtil;

class UncageTheMenagerieEffect
extends OneShotEffect {
    UncageTheMenagerieEffect() {
        super(Outcome.DrawCard);
        this.staticText = "Search your library for up to X creature cards with different names that each have mana value X, reveal them, put them into your hand, then shuffle.";
    }

    private UncageTheMenagerieEffect(UncageTheMenagerieEffect effect) {
        super((OneShotEffect)effect);
    }

    public UncageTheMenagerieEffect copy() {
        return new UncageTheMenagerieEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int xValue = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
        FilterCreatureCard filter = new FilterCreatureCard(xValue + " creature cards with different names that each have mana value " + xValue);
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.EQUAL_TO, xValue));
        return new SearchLibraryPutInHandEffect((TargetCardInLibrary)new TargetCardWithDifferentNameInLibrary(0, xValue, (FilterCard)filter), true).apply(game, source);
    }
}

