/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class UncivilUnrestDamageEffect
extends ReplacementEffectImpl {
    UncivilUnrestDamageEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Damage);
        this.staticText = "if a creature you control with a +1/+1 counter on it would deal damage to a permanent or player, it deals double that damage instead";
    }

    private UncivilUnrestDamageEffect(UncivilUnrestDamageEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public UncivilUnrestDamageEffect copy() {
        return new UncivilUnrestDamageEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType().equals((Object)GameEvent.EventType.DAMAGE_PLAYER) || event.getType().equals((Object)GameEvent.EventType.DAMAGE_PERMANENT);
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent permanent = game.getPermanent(event.getSourceId());
        return permanent != null && permanent.getCounters(game).containsKey(CounterType.P1P1) && game.getControllerId(event.getSourceId()).equals(source.getControllerId());
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        event.setAmount(CardUtil.overflowMultiply((int)event.getAmount(), (int)2));
        return false;
    }
}

