/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.abilities.effects.common.ExileTargetEffect;
import mage.cards.Card;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.token.Token;
import mage.game.permanent.token.ZombieToken;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class UndeadAlchemistTriggeredAbility
extends TriggeredAbilityImpl {
    public UndeadAlchemistTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new ExileTargetEffect(), false);
        this.addEffect((Effect)new CreateTokenEffect((Token)new ZombieToken()));
    }

    private UndeadAlchemistTriggeredAbility(UndeadAlchemistTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public UndeadAlchemistTriggeredAbility copy() {
        return new UndeadAlchemistTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Card card;
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        if (zEvent.getFromZone() == Zone.LIBRARY && zEvent.getToZone() == Zone.GRAVEYARD && game.getOpponents(this.getControllerId()).contains(zEvent.getPlayerId()) && (card = game.getCard(event.getTargetId())) != null && card.isCreature(game)) {
            if (game.getState().getZone(card.getId()) == Zone.GRAVEYARD) {
                ((Effect)this.getEffects().get(0)).setTargetPointer((TargetPointer)new FixedTarget(card, game));
            }
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever a creature card is put into an opponent's graveyard from their library, exile that card and create a 2/2 black Zombie creature token.";
    }
}

