/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import mage.ApprovingObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class UnexpectedResultEffect
extends OneShotEffect {
    UnexpectedResultEffect() {
        super(Outcome.PlayForFree);
        this.staticText = "Shuffle your library, then reveal the top card. If it's a nonland card, you may cast it without paying its mana cost. If it's a land card, you may put it onto the battlefield and return {this} to its owner's hand";
    }

    private UnexpectedResultEffect(UnexpectedResultEffect effect) {
        super((OneShotEffect)effect);
    }

    public UnexpectedResultEffect copy() {
        return new UnexpectedResultEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Card sourceCard = game.getCard(source.getSourceId());
        if (controller == null || sourceCard == null) {
            return false;
        }
        if (controller.getLibrary().hasCards()) {
            controller.shuffleLibrary(source, game);
            Card card = controller.getLibrary().getFromTop(game);
            if (card == null) {
                return false;
            }
            controller.revealCards(sourceCard.getName(), (Cards)new CardsImpl(card), game);
            if (card.isLand(game)) {
                String message = "Put " + card.getName() + " onto the battlefield?";
                if (controller.chooseUse(Outcome.PutLandInPlay, message, source, game)) {
                    controller.moveCards(card, Zone.BATTLEFIELD, source, game);
                    controller.moveCards(sourceCard, Zone.HAND, source, game);
                    return true;
                }
            } else if (controller.chooseUse(this.outcome, "Cast " + card.getName() + " without paying its mana cost?", source, game)) {
                game.getState().setValue("PlayFromNotOwnHandZone" + card.getId(), (Object)Boolean.TRUE);
                Boolean cardWasCast = controller.cast(controller.chooseAbilityForCast(card, game, true), game, true, new ApprovingObject(source, game));
                game.getState().setValue("PlayFromNotOwnHandZone" + card.getId(), null);
                return cardWasCast;
            }
            return true;
        }
        return false;
    }
}

