/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DestroyTargetEffect;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterArtifactOrEnchantmentPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.target.TargetPermanent;

class UnleashTheInfernoEffect
extends OneShotEffect {
    UnleashTheInfernoEffect() {
        super(Outcome.Benefit);
        this.staticText = "{this} deals 7 damage to target creature or planeswalker. When it deals excess damage this way, destroy target artifact or enchantment an opponent controls with mana value less than or equal to that amount of excess damage";
    }

    private UnleashTheInfernoEffect(UnleashTheInfernoEffect effect) {
        super((OneShotEffect)effect);
    }

    public UnleashTheInfernoEffect copy() {
        return new UnleashTheInfernoEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            return false;
        }
        int excess = permanent.damageWithExcess(7, source, game);
        if (excess < 1) {
            return true;
        }
        ReflexiveTriggeredAbility ability = new ReflexiveTriggeredAbility((Effect)new DestroyTargetEffect(), false);
        FilterArtifactOrEnchantmentPermanent filter = new FilterArtifactOrEnchantmentPermanent("artifact or enchantment an opponent controls with mana value less than or equal to " + excess);
        filter.add((ObjectSourcePlayerPredicate)TargetController.OPPONENT.getControllerPredicate());
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, excess + 1));
        ability.addTarget((Target)new TargetPermanent((FilterPermanent)filter));
        game.fireReflexiveTriggeredAbility(ability, source);
        return true;
    }
}

