/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.CardsImpl;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.PowerPredicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class UnstableGlyphbridgeEffect
extends OneShotEffect {
    UnstableGlyphbridgeEffect() {
        super(Outcome.Benefit);
        this.staticText = "for each player, choose a creature with power 2 or less that player controls. Then destroy all creatures except creatures chosen this way.";
    }

    private UnstableGlyphbridgeEffect(UnstableGlyphbridgeEffect effect) {
        super((OneShotEffect)effect);
    }

    public UnstableGlyphbridgeEffect copy() {
        return new UnstableGlyphbridgeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            FilterCreaturePermanent filter = new FilterCreaturePermanent("creature with power 2 or less");
            filter.add((Predicate)new PowerPredicate(ComparisonType.OR_LESS, 2));
            filter.add((Predicate)new ControllerIdPredicate(playerId));
            TargetPermanent target = new TargetPermanent((FilterPermanent)filter);
            target.withNotTarget(true);
            target.withChooseHint(player.getName() + " controls");
            controller.choose(Outcome.PutCreatureInPlay, (Target)target, source, game);
            cards.add((Object)target.getFirstTarget());
        }
        for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURES, source.getControllerId(), source, game)) {
            if (cards.contains((Object)permanent.getId())) continue;
            permanent.destroy(source, game);
        }
        return true;
    }
}

