/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.PhaseStep;
import mage.constants.SubLayer;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterArtifactPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;

class UnwindingClockEffect
extends ContinuousEffectImpl {
    private static FilterArtifactPermanent filter = new FilterArtifactPermanent();

    public UnwindingClockEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "Untap all artifacts you control during each other player's untap step";
    }

    private UnwindingClockEffect(UnwindingClockEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public UnwindingClockEffect copy() {
        return new UnwindingClockEffect(this);
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        boolean applied = Boolean.TRUE.equals(game.getState().getValue(source.getSourceId() + "applied"));
        if (!applied && layer == Layer.RulesEffects) {
            if (!game.isActivePlayer(source.getControllerId()) && game.getTurnStepType() == PhaseStep.UNTAP) {
                game.getState().setValue(source.getSourceId() + "applied", (Object)true);
                for (Permanent artifact : game.getBattlefield().getAllActivePermanents((FilterPermanent)filter, source.getControllerId(), game)) {
                    boolean untap = true;
                    for (RestrictionEffect effect : game.getContinuousEffects().getApplicableRestrictionEffects(artifact, game).keySet()) {
                        untap &= effect.canBeUntapped(artifact, source, game, true);
                    }
                    if (!untap) continue;
                    artifact.untap(game);
                }
            }
        } else if (applied && layer == Layer.RulesEffects && game.getTurnStepType() == PhaseStep.END_TURN) {
            game.getState().setValue(source.getSourceId() + "applied", (Object)false);
        }
        return true;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.RulesEffects;
    }
}

