/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.cards.u.PlayCreatureLandWatcher;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.watchers.common.PermanentWasCastWatcher;

class UphillBattleTapEffect
extends ReplacementEffectImpl {
    UphillBattleTapEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Tap);
        this.staticText = "Creatures played by your opponents enter the battlefield tapped";
    }

    private UphillBattleTapEffect(UphillBattleTapEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Permanent target = ((EntersTheBattlefieldEvent)event).getTarget();
        PermanentWasCastWatcher creatureSpellWatcher = (PermanentWasCastWatcher)game.getState().getWatcher(PermanentWasCastWatcher.class);
        PlayCreatureLandWatcher landWatcher = (PlayCreatureLandWatcher)game.getState().getWatcher(PlayCreatureLandWatcher.class);
        if (target != null && (creatureSpellWatcher != null && creatureSpellWatcher.wasPermanentCastThisTurn(target.getId()) || landWatcher != null && landWatcher.wasLandPlayed(target.getId()))) {
            target.setTapped(true);
        }
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent permanent;
        return game.getOpponents(source.getControllerId()).contains(event.getPlayerId()) && (permanent = ((EntersTheBattlefieldEvent)event).getTarget()) != null && permanent.isCreature(game);
    }

    public UphillBattleTapEffect copy() {
        return new UphillBattleTapEffect(this);
    }
}

