/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import java.util.Collection;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.DeathtouchAbility;
import mage.abilities.keyword.DoubleStrikeAbility;
import mage.abilities.keyword.FirstStrikeAbility;
import mage.abilities.keyword.FlyingAbility;
import mage.abilities.keyword.HasteAbility;
import mage.abilities.keyword.HexproofBaseAbility;
import mage.abilities.keyword.IndestructibleAbility;
import mage.abilities.keyword.LifelinkAbility;
import mage.abilities.keyword.MenaceAbility;
import mage.abilities.keyword.ReachAbility;
import mage.abilities.keyword.TrampleAbility;
import mage.abilities.keyword.VigilanceAbility;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.ExileZone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class UrborgScavengersEffect
extends ContinuousEffectImpl {
    UrborgScavengersEffect() {
        super(Duration.WhileOnBattlefield, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.staticText = "{this} has flying as long as a card exiled with it has flying. The same is true for first strike, double strike, deathtouch, haste, hexproof, indestructible, lifelink, menace, reach, trample, and vigilance";
    }

    private UrborgScavengersEffect(UrborgScavengersEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public UrborgScavengersEffect copy() {
        return new UrborgScavengersEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent sourcePermanent = game.getPermanent(source.getSourceId());
        if (sourcePermanent == null) {
            return false;
        }
        ExileZone exileZone = game.getExile().getExileZone(CardUtil.getExileZoneId((Game)game, (UUID)source.getSourceId(), (int)sourcePermanent.getZoneChangeCounter(game)));
        if (exileZone == null || exileZone.isEmpty()) {
            return false;
        }
        exileZone.getCards(game).stream().map(card -> card.getAbilities(game)).flatMap(Collection::stream).forEach(ability -> {
            if (ability instanceof FlyingAbility || ability instanceof FirstStrikeAbility || ability instanceof DoubleStrikeAbility || ability instanceof DeathtouchAbility || ability instanceof HasteAbility || ability instanceof HexproofBaseAbility || ability instanceof IndestructibleAbility || ability instanceof LifelinkAbility || ability instanceof MenaceAbility || ability instanceof ReachAbility || ability instanceof TrampleAbility || ability instanceof VigilanceAbility) {
                sourcePermanent.addAbility(ability, source.getSourceId(), game);
            }
        });
        return true;
    }
}

