/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import java.util.Optional;
import java.util.UUID;
import mage.MageIdentifier;
import mage.abilities.Ability;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.costs.mana.ManaCosts;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.cards.Card;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Exile;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class UriangerAugureltPlayEffect
extends AsThoughEffectImpl {
    UriangerAugureltPlayEffect() {
        super(AsThoughEffectType.PLAY_FROM_NOT_OWN_HAND_ZONE, Duration.EndOfTurn, Outcome.AIDontUseIt);
        this.staticText = "until end of turn, you may play cards exiled with {this}. Spells you cast this way cost {2} less to cast";
    }

    private UriangerAugureltPlayEffect(UriangerAugureltPlayEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public UriangerAugureltPlayEffect copy() {
        return new UriangerAugureltPlayEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public boolean applies(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        Card card;
        block8: {
            block7: {
                if (!source.isControlledBy(affectedControllerId)) {
                    return false;
                }
                card = game.getCard(objectId);
                if (card == null) break block7;
                if (Optional.ofNullable(CardUtil.getExileZoneId((Game)game, (Ability)source)).map(arg_0 -> ((Exile)game.getState().getExile()).getExileZone(arg_0)).filter(e -> e.contains((Object)objectId)).isPresent()) break block8;
            }
            return false;
        }
        if (card.isLand(game)) {
            return true;
        }
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            ManaCosts newCost = CardUtil.reduceCost((ManaCosts)card.getManaCost(), (int)2);
            if (newCost.isEmpty()) {
                newCost.add((Object)new GenericManaCost(0));
            }
            controller.setCastSourceIdWithAlternateMana(card.getId(), newCost, null, MageIdentifier.UriangerAugureltAlternateCast);
        }
        return true;
    }
}

