/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import java.util.LinkedHashSet;
import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.choices.Choice;
import mage.choices.ChoiceImpl;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.game.Game;
import mage.players.Player;

class UrzaAcademyHeadmasterManaEffect
extends OneShotEffect {
    UrzaAcademyHeadmasterManaEffect() {
        super(Outcome.PutManaInPool);
    }

    private UrzaAcademyHeadmasterManaEffect(UrzaAcademyHeadmasterManaEffect effect) {
        super((OneShotEffect)effect);
    }

    public UrzaAcademyHeadmasterManaEffect copy() {
        return new UrzaAcademyHeadmasterManaEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player != null) {
            int x = game.getBattlefield().count((FilterPermanent)new FilterControlledCreaturePermanent(), source.getControllerId(), source, game);
            ChoiceImpl manaChoice = new ChoiceImpl(false);
            LinkedHashSet<String> choices = new LinkedHashSet<String>();
            choices.add("White");
            choices.add("Blue");
            choices.add("Black");
            choices.add("Red");
            choices.add("Green");
            manaChoice.setChoices(choices);
            manaChoice.setMessage("Select color of mana to add");
            for (int i = 0; i < x; ++i) {
                Mana mana = new Mana();
                if (!player.choose(Outcome.Benefit, (Choice)manaChoice, game)) {
                    return false;
                }
                if (manaChoice.getChoice() == null) {
                    return false;
                }
                switch (manaChoice.getChoice()) {
                    case "White": {
                        mana.increaseWhite();
                        break;
                    }
                    case "Blue": {
                        mana.increaseBlue();
                        break;
                    }
                    case "Black": {
                        mana.increaseBlack();
                        break;
                    }
                    case "Red": {
                        mana.increaseRed();
                        break;
                    }
                    case "Green": {
                        mana.increaseGreen();
                    }
                }
                player.getManaPool().addMana(mana, game, source);
            }
            return true;
        }
        return false;
    }
}

