/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class UrzaAssemblesTheTitansScryEffect
extends OneShotEffect {
    UrzaAssemblesTheTitansScryEffect() {
        super(Outcome.Benefit);
        this.staticText = "Scry 4, then you may reveal the top card of your library. If a planeswalker card is revealed this way, put it into your hand.";
    }

    private UrzaAssemblesTheTitansScryEffect(UrzaAssemblesTheTitansScryEffect effect) {
        super((OneShotEffect)effect);
    }

    public UrzaAssemblesTheTitansScryEffect copy() {
        return new UrzaAssemblesTheTitansScryEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        controller.scry(4, source, game);
        Card card = controller.getLibrary().getFromTop(game);
        if (card != null && controller.chooseUse(this.outcome, "Reveal the top card of your library?", source, game)) {
            controller.revealCards(source, (Cards)new CardsImpl(card), game);
            if (card.isPlaneswalker(game)) {
                controller.moveCards(card, Zone.HAND, source, game);
            }
        }
        return true;
    }
}

